﻿Imports System.Data.OleDb
Public Class AdministrationDatabase
    Dim connectionString As String =
     "Provider=Microsoft.ACE.OLEDB.12.0;
        Data Source=C:\Users\Joyce\Desktop\Misaki's stuff\UNIVERSITY STUFF\INTRO TO VISUAL PROGRAMMING\VP Group Assignment (22-11-19)\Database for VP Group Assignment.accdb"
    Private Sub AdministrationDatabase_Load(sender As Object, e As EventArgs) Handles MyBase.Load

        loadDatabaseTable()
        loadDatabaseTable2()

    End Sub

    Private Sub loadDatabaseTable()

        Using cn As New OleDbConnection(connectionString) 'establish database connection
            Using cmd As New OleDbCommand With {.Connection = cn} 'prepare SQL object based 
                cmd.CommandText = "SELECT * FROM CourseTable;" 'giving SQL command into SQL
                Dim dt As New DataTable With {.TableName = "CourseTable"} 'create new table in Visual Studio to store database table later
                Try
                    cn.Open()
                    Dim ds As New DataSet
                    Dim CourseTable As New DataTable With {.TableName = "CourseTable"}
                    ds.Tables.Add(CourseTable)
                    ds.Load(cmd.ExecuteReader(), LoadOption.OverwriteChanges, CourseTable)

                    DataGridView.DataSource = ds.Tables("CourseTable")
                    ' DataGridView.Columns("empID").Visible = False

                    cn.Close()

                Catch ex As Exception
                    'very common for a developer to simply ignore errors, unwise.
                End Try
            End Using
        End Using

    End Sub
    Private Sub loadDatabaseTable2()

        Using cn As New OleDbConnection(connectionString) 'establish database connection
            Using cmd As New OleDbCommand With {.Connection = cn} 'prepare SQL object based 
                cmd.CommandText = "SELECT * FROM LecturerTable;" 'giving SQL command into SQL
                Dim dt As New DataTable With {.TableName = "LecturerTable"} 'create new table in Visual Studio to store database table later
                Try
                    cn.Open()
                    Dim ds As New DataSet
                    Dim LecturerTable As New DataTable With {.TableName = "LecturerTable"}
                    ds.Tables.Add(LecturerTable)
                    ds.Load(cmd.ExecuteReader(), LoadOption.OverwriteChanges, LecturerTable)

                    DataGridView1.DataSource = ds.Tables("LecturerTable")
                    ' DataGridView.Columns("empID").Visible = False

                    cn.Close()

                Catch ex As Exception
                    'very common for a developer to simply ignore errors, unwise.
                End Try
            End Using
        End Using

    End Sub

    Private Sub BtnSearchCourse_Click(sender As Object, e As EventArgs) Handles btnSearchCourse.Click
        Dim cn As New OleDbConnection(connectionString) 'establish database connection
        Dim cmd As New OleDbCommand With {.Connection = cn} 'prepare SQL object based on the database connection
        cmd.CommandText = "SELECT * FROM CourseTable
                    WHERE courseID = ?;" 'giving SQL command into SQL object

        Try
            cmd.Parameters.AddWithValue("?", txtCourseID.Text)
            cn.Open()

            cmd.Connection = cn
            Dim dr As OleDbDataReader = cmd.ExecuteReader

            If dr.Read Then
                txtCourseName.Text = dr.Item("courseName")
                txtCourseID.Text = dr.Item("courseID")
                txtCourseLecturerName.Text = dr.Item("lecturerName")
            Else
                MessageBox.Show("Invalid Course ID")
            End If

            cn.Close()

        Catch ex As Exception
            ' very common for a developer to simply ignore errors, unwise.
            MessageBox.Show(ex.ToString)
        End Try
    End Sub

    Private Sub BtnAddCourse_Click(sender As Object, e As EventArgs) Handles btnAddCourse.Click
        Using cn As New OleDbConnection(connectionString)
            Using cmd As New OleDbCommand With {.Connection = cn}
                cmd.CommandText = "INSERT INTO CourseTable (courseID, courseName, lecturerName) 
                    VALUES (?,?,?)"
                cmd.Parameters.AddWithValue("?", txtCourseID.Text)
                cmd.Parameters.AddWithValue("?", txtCourseName.Text)
                cmd.Parameters.AddWithValue("?", txtCourseLecturerName.Text)
                Try
                    cn.Open()
                    cmd.ExecuteNonQuery()
                    cn.Close()
                Catch ex As Exception
                    MessageBox.Show("Error")
                End Try
                loadDatabaseTable()
            End Using
        End Using
    End Sub

    Private Sub BtnSearchLecturer_Click(sender As Object, e As EventArgs) Handles btnSearchLecturer.Click
        Dim cn As New OleDbConnection(connectionString) 'establish database connection
        Dim cmd As New OleDbCommand With {.Connection = cn} 'prepare SQL object based on the database connection
        cmd.CommandText = "SELECT * FROM LecturerTable
                    WHERE lecturerID = ?;" 'giving SQL command into SQL object

        Try
            cmd.Parameters.AddWithValue("?", txtLecturerID.Text)
            cn.Open()

            cmd.Connection = cn
            Dim dr As OleDbDataReader = cmd.ExecuteReader

            If dr.Read Then
                txtLecturerName.Text = dr.Item("lecturerName")
                txtLecturerID.Text = dr.Item("lecturerID")
                txtLecturerCourse.Text = dr.Item("courseID")
            Else
                MessageBox.Show("Invalid Lecturer ID")
            End If

            cn.Close()

        Catch ex As Exception
            ' very common for a developer to simply ignore errors, unwise.
            MessageBox.Show(ex.ToString)
        End Try
    End Sub

    Private Sub BtnAddLecturer_Click(sender As Object, e As EventArgs) Handles btnAddLecturer.Click
        Using cn As New OleDbConnection(connectionString)
            Using cmd As New OleDbCommand With {.Connection = cn}
                cmd.CommandText = "INSERT INTO LecturerTable (lecturerID, lecturerName, courseID) 
                    VALUES (?,?,?)"
                cmd.Parameters.AddWithValue("?", txtLecturerID.Text)
                cmd.Parameters.AddWithValue("?", txtLecturerName.Text)
                cmd.Parameters.AddWithValue("?", txtLecturerCourse.Text)
                Try
                    cn.Open()
                    cmd.ExecuteNonQuery()
                    cn.Close()
                Catch ex As Exception
                    MessageBox.Show("Error")
                End Try
                loadDatabaseTable()
            End Using
        End Using
    End Sub

    Private Sub BtnDeleteLecturer_Click(sender As Object, e As EventArgs) Handles btnDeleteLecturer.Click
        Using cn As New OleDbConnection(connectionString)
            Using cmd As New OleDbCommand With {.Connection = cn}
                cmd.CommandText = "DELETE FROM LecturerTable WHERE lecturerID = ?"
                cmd.Parameters.AddWithValue("?", txtLecturerID.Text)
                Try
                    cn.Open()
                    cmd.ExecuteNonQuery()
                    cn.Close()
                Catch ex As Exception
                    MessageBox.Show("Error")
                End Try

                loadDatabaseTable()

            End Using
        End Using
    End Sub

    Private Sub BtnDeleteCourse_Click(sender As Object, e As EventArgs) Handles btnDeleteCourse.Click
        Using cn As New OleDbConnection(connectionString)
            Using cmd As New OleDbCommand With {.Connection = cn}
                cmd.CommandText = "DELETE FROM CourseTable WHERE courseID = ?"
                cmd.Parameters.AddWithValue("?", txtCourseID.Text)
                Try
                    cn.Open()
                    cmd.ExecuteNonQuery()
                    cn.Close()
                Catch ex As Exception
                    MessageBox.Show("Error")
                End Try

                loadDatabaseTable()

            End Using
        End Using
    End Sub

    Private Sub BtnUpdateCourse_Click(sender As Object, e As EventArgs) Handles btnUpdateCourse.Click
        Using cn As New OleDbConnection(connectionString)
            Using cmd As New OleDbCommand With {.Connection = cn}
                cmd.CommandText = "UPDATE CourseTable 
                    SET courseName = ?, lecturerName = ? WHERE courseID = ?"
                cmd.Parameters.AddWithValue("?", txtCourseName.Text)
                cmd.Parameters.AddWithValue("?", txtCourseLecturerName.Text)
                cmd.Parameters.AddWithValue("?", txtCourseID.Text)
                Try
                    cn.Open()
                    cmd.ExecuteNonQuery()
                    cn.Close()
                Catch ex As Exception
                    MessageBox.Show("Error")
                End Try
                loadDatabaseTable()
            End Using
        End Using
    End Sub

    Private Sub CourseReportToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles CourseReportToolStripMenuItem.Click
        Dim frmCourseEvaluation As New CourseEvaluationReport
        frmCourseEvaluation.ShowDialog()
    End Sub

    Private Sub LecturerReportToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles LecturerReportToolStripMenuItem.Click
        Dim frmLecturerEvaluation As New LecturerEvaluationReport
        frmLecturerEvaluation.ShowDialog()
    End Sub

    Private Sub btnUpdateLecturer_Click(sender As Object, e As EventArgs) Handles btnUpdateLecturer.Click
        Using cn As New OleDbConnection(connectionString)
            Using cmd As New OleDbCommand With {.Connection = cn}
                cmd.CommandText = "UPDATE LecturerTable 
                    SET courseID = ?, lecturerName = ? WHERE lecturerID = ?"
                cmd.Parameters.AddWithValue("?", txtLecturerCourse.Text)
                cmd.Parameters.AddWithValue("?", txtLecturerName.Text)
                cmd.Parameters.AddWithValue("?", txtLecturerID.Text)
                Try
                    cn.Open()
                    cmd.ExecuteNonQuery()
                    cn.Close()
                Catch ex As Exception
                    MessageBox.Show("Error")
                End Try
                loadDatabaseTable()
            End Using
        End Using
    End Sub
End Class